# !/usr/bin/perl -w
####################################
##        Interface/Appli         ##
####################################


#Utilisation des modules suivants:
use strict;
use Gtk2 '-init';
use Gtk2::GladeXML;

#Ouverture juste du code XML de la fenêtre d'accueil et branchement des callbacks.
my $gladexml = Gtk2::GladeXML->new('gui.glade');
$gladexml->signal_autoconnect_from_package('callbacks');

#Récupération des différents widgets.
my $input_texte = $gladexml->get_widget('input_texte'); 
my $text_buffer = $input_texte->get_buffer;
my $input_resultat = $gladexml->get_widget('input_resultat');
my $input_regex = $gladexml->get_widget('input_regex'); 
my $a_propos = $gladexml->get_widget('f_apropos');

#Boucle:
Gtk2->main;


################################
##         Callbacks          ##
################################

#Nom du module.
package callbacks;

#Pour quitter l'application
sub on_f_principale_delete_event{
Gtk2->main_quit ;
}
sub  on_quitter_activate {
Gtk2->main_quit;
}

#Les boutons d'effacement
sub on_bouton_effacer_texte_clicked {
	$text_buffer->set_text('');
}
sub on_bouton_effacer_regex_clicked {
	$input_regex->set_text('');
}

#Le bouton de test du regex
sub on_bouton_valider_clicked {
	my $regex = $input_regex->get_text;
	my $texte = $text_buffer->get_text($text_buffer->get_start_iter,$text_buffer->get_end_iter,'FALSE');
	my $regex_use = qr/$regex/i;
	if ($texte =~ $regex_use)
	{
		$input_resultat->set_text('Le regex correspond !');
	}
	else
	{
		$input_resultat->set_text('Le regex ne correspond pas !');
	}
}


#La fenêtre à propos
sub on_a_propos_activate {
	$a_propos->show;
}

return 1; 
